<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class w_ts3viewerv2_c_index extends Controller_Widget
{
	public function index($settings = [])
	{
		$this->css('teamspeak');

		include('files/class.ts3viewer.php');
		$ts3 = new ts3viewer($settings['addr'], $settings['qport'], '', $settings['port'], $settings['skin']);
		$ts3->build();

		$adminsonline = '0';

		foreach ($ts3->plist as $client)  
		{
			if ($client['client_talk_power'] >= '75')
			{
				$adminsonline++;

		 		if ($client['client_input_muted'] == '1' || $client['client_output_muted'] == '1' || $client['client_away'] == '1')
				{
					$afk = '1';
				}
				else
				{
					$afk = '0';
				}

				$admins[$client['client_database_id']] = [
					'pseudo' => $client['client_nickname'],
					'afk'    => $afk
				];
		 	}
		}

		if ($settings['tabinfoshow'] == "0" && $settings['tabadminshow'] == "0")
		{
			$tabwidth = '100';
		}
		elseif ($settings['tabinfoshow'] == "1" && $settings['tabadminshow'] == "1")
		{
			$tabwidth = '33.33';
		}
		elseif ($settings['tabinfoshow'] == "0" && $settings['tabadminshow'] == "1")
		{
			$tabwidth = '50';
		}
		elseif ($settings['tabinfoshow'] == "1" && $settings['tabadminshow'] == "0")
		{
			$tabwidth = '50';
		}

		return $this->panel()
					->heading($ts3->tree_name(), 'fa-microphone')
					->body($this->view('index', [
						'ts3viewer'      => '<div class="ts3viewer">'.$ts3->tree().'</div>',
						'onlineusers'    => $ts3->useron(),
						'platform'       => $ts3->sinfo['virtualserver_platform'],
						'ping'           => $ts3->sinfo['virtualserver_total_ping'],
						'adminsonline'   => $adminsonline, 
						'admins'         => $admins,
						'tabwidth'       => $tabwidth,
						'cfg'            => $settings,
						'serverpassword' => $ts3->sinfo['virtualserver_flag_password'] !== '0' ? "oui" : "non"
					]))
					->footer_if($settings['display'] !== false, '<a class="btn btn-primary btn-lg btn-block" href="ts3server://'.$settings['addr'].':'.$settings['port'].'"><i class="fa fa-comments-o"></i> Se connecter au serveur</a>', 'right');
	}
}

/*
NeoFrag Alpha 0.1.6
./widgets/ts3viewerv2/controllers/index.php
*/