<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class minecraft_server
{
	private $address;
	private $port;

	public function __construct($address, $port){
		$this->address = $address;
		$this->port = $port;
	}

	public function get_ping_info(&$info)
	{
		$socket = @fsockopen($this->address, $this->port, $errno, $errstr, 1.0);

		if ($socket === FALSE){
			return FALSE;
		}

		fwrite($socket, "\xfe\x01");

		$data = fread($socket, 256);

		if (substr($data, 0, 1) != "\xff"){
			return FALSE;
		}

		if (substr($data, 3, 5) == "\x00\xa7\x00\x31\x00")
		{
			$data = explode("\x00", mb_convert_encoding(substr($data, 15), 'UTF-8', 'UCS-2'));
		}
		else
		{
			$data = explode('§', mb_convert_encoding(substr($data, 3), 'UTF-8', 'UCS-2'));
		}

		$info = array(
			'version'     => $data[1],
			'motd'        => $data[2],
			'players'     => intval($data[3]),
			'max_players' => intval($data[4]),
			'percent'     => ceil($data[3] * 100 / $data[4]),
			'adress'      => $this->address
		);

		return TRUE;
	}
}

/*
NeoFrag Alpha 0.1.4.1
./widgets/mcserver/inc/minecraft.php
*/