<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

require (dirname(__FILE__).'/vesu/SDK/Gw2/Gw2SDK.php');
require (dirname(__FILE__) .'/vesu/SDK/Gw2/Gw2Exception.php');

use vesu\SDK\Gw2\Gw2SDK;
use vesu\SDK\Gw2\Gw2Exception;

class w_gw2wvw_c_index extends Controller_Widget
{
    public function index($settings = array())
    {
		$cachedir = dirname(__FILE__).'/cache';
		
		if (substr(decoct(fileperms($cachedir)),2) != '777')
		{
			$gw2 = new Gw2SDK;
		}
		else
		{
			$gw2 = new Gw2SDK(dirname(__FILE__).'/cache');
		}

		$world_home_id = $settings['world_id'];

		$matches = $gw2->getMatchByWorldId($world_home_id);
		
		foreach($matches as $match)
		{
			$scores = $gw2->getScoresByMatchId($match->wvw_match_id);
		}
		
		$world_names_dir = file_get_contents(dirname(__FILE__).'/world_names.json');
		$world_names = json_decode($world_names_dir,true);
		
		foreach($world_names as $world)
		{
			if($world['id'] == $match->red_world_id) { $red_world_name = $world['name']; }
			if($world['id'] == $match->blue_world_id) { $blue_world_name = $world['name']; }
			if($world['id'] == $match->green_world_id) { $green_world_name = $world['name']; }
			if($match->red_world_id == $world_home_id) { $red_world_home = "home-world"; } else { $red_world_home = ""; }
			if($match->blue_world_id == $world_home_id) { $blue_world_home = "home-world"; } else { $blue_world_home = ""; }
			if($match->green_world_id == $world_home_id) { $green_world_home = "home-world"; } else { $green_world_home = ""; }
		}

		$match_sort = array(
			"red" => array("world_score" => $scores[0], "world_color" => "red", "world_name" => $red_world_name, "world_home" => $red_world_home),
			"blue" => array("world_score" => $scores[1], "world_color" => "blue", "world_name" => $blue_world_name, "world_home" => $blue_world_home),
			"green" => array("world_score" => $scores[2], "world_color" => "green", "world_name" => $green_world_name, "world_home" => $green_world_home)
		);

		arsort($match_sort);

		$this->css('gw2wvw');

		return new Panel(array(
			'title'   => 'GW2 World Vs World',
			'content' => $this->load->view('index', array(
				'match_sort' => $match_sort,
				'world_id'   => $settings['world_id'],
			))
		));
    }
}

/*
NeoFrag Alpha 0.1.3
./widgets/gw2timer/controllers/index.php
*/