<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class w_nserv_c_index extends Controller_Widget
{
	public function index($settings = array())
	{
		require_once 'widgets/nserv/SourceQuery/SourceQuery.class.php';

		$Query = new SourceQuery;

		$title = $content = '';

		try
		{
			$Query->Connect($settings['addr'], $settings['port'], 1, SourceQuery::SOURCE);

			if ($nservData = $Query->GetInfo())
			{
				$content = $this->view('index', array(
					'nserv_hostname' => $nservData['HostName'],
					'nserv_game'     => $title = $nservData['ModDesc'],
					'nserv_users'    => $nservData['Players'].'/'.$nservData['MaxPlayers'],
					'nserv_vac'      => $nservData['Secure'] ? 'VAC' : 'noVAC',
					'nserv_map'      => $nservData['Map']
				));
			}
			else
			{
				$content = '<h3>Jeu non pris en charge ou Serveur Hors Ligne<h3>';
			}
		}
		catch (Exception $e)
		{
			$content = 'Jeu non pris en charge ou Serveur Hors Ligne';
		}

		$Query->Disconnect();

		return $this->panel()
					->heading($title, 'fa-gamepad')
					->body($content)
					->footer('<a class="btn btn-primary btn-lg btn-block" href="steam://connect/'.$settings['addr'].':'.$settings['port'].'"><i class="fa fa-steam"></i> Se connecter au serveur</a>', 'right');
	}
}

/*
NeoFrag Alpha 0.1.3
./widgets/nserv/controllers/index.php
*/